/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIResourcesAllocationUtils;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class PICommonUtilMethods {
    public static String getLPARNameFromInstance(CIMInstance cIMInstance) {
        return (String)cIMInstance.getProperty("Name").getValue().getValue();
    }

    public static int getLPARIDFromInstance(CIMInstance cIMInstance) {
        String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
        int n = -1;
        if (string == null) {
            System.out.println("MKS:getLPARIDFromInstance: lpar name is NULL");
        } else {
            try {
                n = Integer.parseInt(string.substring(0, string.indexOf("*")));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MKS:getLPARIDFromInstance: lpar name is in incorrect format");
            }
        }
        return n;
    }

    public static CIMInstance getTheInstanceFromName(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath, String string) throws CIMException {
        CIMObjectPath cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string, "root/ibmhscS1_0");
        return PICommonUtilMethods.getTheInstance(providerCIMOMHandle, cIMObjectPath2);
    }

    public static CIMInstance getTheInstance(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        }
        catch (CIMException cIMException) {
            System.out.println("ERROR: cannot find partition isntance");
            throw cIMException;
        }
        if (cIMInstance == null) {
            System.out.println("ERROR: cannot find partition isntance");
            return null;
        }
        return cIMInstance;
    }

    public static int getModeFromInstance(CIMInstance cIMInstance) {
        return ((UnsignedInt8)cIMInstance.getProperty("Mode").getValue().getValue()).intValue();
    }

    public static boolean checkModeAndState(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath, String string) throws CIMException {
        CIMInstance cIMInstance = PICommonUtilMethods.getTheInstanceFromName(providerCIMOMHandle, cIMObjectPath, string);
        if (cIMInstance == null) {
            System.out.println("MKS:invokeMethodImpl: ERROR Cec Instance is null");
            return false;
        }
        int n = PICommonUtilMethods.getModeFromInstance(cIMInstance);
        if (1 == n || 3 == n) {
            System.out.println("ERROR: cannot get partition SRC when the managed system is not in lpar mode");
            return false;
        }
        int n2 = ((UnsignedInt8)cIMInstance.getProperty("State").getValue().getValue()).intValue();
        if (1 != n2) {
            System.out.println("ERROR: cannot get partition SRC when PHYP is not ready");
            return false;
        }
        return true;
    }

    public static boolean isStorageDevice(UnsignedInt16 unsignedInt16) {
        if (unsignedInt16 == null) {
            return false;
        }
        int n = unsignedInt16.intValue();
        System.out.println("classCode = " + n);
        System.out.println("PIHscConstants.SCSI_DEV_RANGE0 = 256");
        System.out.println("PIHscConstants.SCSI_DEV_RANGE1 = 511");
        if (n >= 256 && n <= 511) {
            int n2 = n & 0xFF;
            if (n2 == 1) {
                return false;
            }
            return n2 != 2;
        }
        return unsignedInt16.equals((Object)new UnsignedInt16(3076));
    }

    public static boolean underIOPAndStorageDev(CIMInstance cIMInstance, String string) {
        CIMObjectPath cIMObjectPath;
        if (cIMInstance == null) {
            return false;
        }
        Object var2_2 = null;
        RObject rObject = null;
        try {
            cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), string);
            cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
            RObjectId rObjectId = new RObjectId(cIMObjectPath);
            rObject = rObjectId.getObject();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (rObject == null) {
            return false;
        }
        cIMObjectPath = null;
        try {
            cIMObjectPath = (UnsignedInt16)rObject.getProperty("PCIClassCode");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (PICommonUtilMethods.isStorageDevice((UnsignedInt16)cIMObjectPath)) {
            boolean bl = false;
            try {
                bl = rObject.hasAssociation(R50Define.AID_IBMHSC_SlotInIOPGroup);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            System.out.println("assocToIOP = " + bl);
            if (bl) {
                UnsignedInt16 unsignedInt16 = null;
                try {
                    unsignedInt16 = (UnsignedInt16)rObject.getProperty("IOPInfo");
                    System.out.println("iopInfo = " + unsignedInt16);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (unsignedInt16 != null) {
                    if ((unsignedInt16.intValue() & 1) == 0) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }
}

